﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class controls_BaseControlTextBox : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    public string Text
    {
        get
        {
            return TextBoxID.Text;
        }
        set
        {
            TextBoxID.Text = value;
        }
    }

    public string LabelText
    {
        get
        {
            return LabelforLabelID.Text;
        }
        set
        {
            LabelforLabelID.Text = value;
        }
    }

    public bool IsMultiline
    {
        set
        {
            if (value)
            {
                TextBoxID.TextMode = TextBoxMode.MultiLine;
                TextBoxID.Rows = 3;
            }
        }
    }

    public string Tooltip
    {
        set
        {
            LabelforLabelID.ToolTip = value;
            TextBoxID.ToolTip = value;
        }
    }

    public bool IncludeLabel
    {
        set
        {
            LabelforLabelID.Visible = value;
        }
    }

    public System.Nullable<int> MaxLength
    {
        set
        {
            if (value != null)
            {
                TextBoxID.MaxLength = (int) value;
            }
        }
    }

    public System.Nullable<int> DateElementWidth
    {
        set
        {
            if (value != null)
            {
                TextBoxID.Width = new Unit((int) value);
            }
        }
    }

    public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, System.Nullable<int> maxLength, System.Nullable<int> dataElementWidth)
    {
        if (!string.IsNullOrEmpty(tooltip))
        {
            Tooltip = tooltip;
        }
        if (!string.IsNullOrEmpty(text))
        {
            Text = text;
        }
        if (!string.IsNullOrEmpty(labelText))
        {
            LabelText = labelText;
        }

        IncludeLabel = includeLabel;
        MaxLength = maxLength;
        DateElementWidth = dataElementWidth;
    }
}
